package ga.view.appstate;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.input.InputManager;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.system.Timer;

/**
 * Extended app state that creates its own viewport and stores many required
 * information.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class SceneState extends RootNodeState {
  protected Camera cam;
  protected ViewPort viewPort;
  protected InputManager inputManager;
  protected AssetManager assetManager;
  protected AppStateManager stateManager;
  protected RenderManager renderManager;
  protected Timer timer;
  protected Application app;

  @Override
  public void setEnabled(final boolean enabled) {
    super.setEnabled(enabled);
    if (viewPort != null) {
      if (enabled) {
        if (!renderManager.getMainViews().contains(viewPort)) {

          final ColorRGBA bgColor = viewPort.getBackgroundColor();

          viewPort = renderManager.createMainView("Scene", cam);
          viewPort.setClearFlags(true, true, true);
          viewPort.setBackgroundColor(bgColor);
          viewPort.attachScene(rootNode);
        }
      } else {
        while (viewPort.getProcessors().size() > 0) {
          final SceneProcessor proc = viewPort.getProcessors().get(0);
          viewPort.removeProcessor(proc);
        }

        renderManager.removeMainView(viewPort);
      }
    }
  }

  /**
   * Should be called for the final clean up on exit.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public void finalCleanUp() {
  }

  @Override
  public void initialize(final AppStateManager stateManager,
      final Application app) {
    super.initialize(stateManager, app);
    this.app = app;

    this.inputManager = app.getInputManager();
    this.assetManager = app.getAssetManager();
    this.stateManager = stateManager;
    this.timer = app.getContext().getTimer();
    this.renderManager = app.getRenderManager();

    cam = new Camera(app.getContext().getSettings().getWidth(), app
        .getContext().getSettings().getHeight());
    cam.setFrustumPerspective(45f, (float) cam.getWidth() / cam.getHeight(),
        0.1f, 20f);
    cam.setLocation(new Vector3f(0f, 0f, 10f));
    cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);

    viewPort = renderManager.createMainView("Scene", cam);
    viewPort.setClearFlags(true, true, true);
    viewPort.attachScene(rootNode);
  }

  /**
   * Gets the camera.
   * 
   * @return the camera
   */
  public Camera getCamera() {
    return cam;
  }

}
